﻿using AutoMapper;
using HIPS.PatientSchemas;
using HIPS.Web.UI.ViewModels.PcehrView;

namespace HIPS.Web.UI.Helpers.Mapping.Profiles
{

    /// <summary>
    /// AutoMapper mapping profile for the Patient entity.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="18 November 2013">Initial version.</change>
    /// </history>
    internal class PatientProfile : Profile
    {

        #region Methods

        /// <summary>
        /// Configures the maps available as part of this mapping profile.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="18 November 2013">Initial version.</change>
        /// </history>
        protected override void Configure()
        {
            //Data --> ViewModel:
            Mapper.CreateMap<PatientInHospital, PatientViewModel>()
                .ForMember(dest => dest.DateOfBirth, opt => opt.MapFrom(src => src.DateOfBirth))
                .ForMember(dest => dest.HospitalName, opt => opt.MapFrom(src => src.HospitalName))
                .ForMember(dest => dest.IHI, opt => opt.MapFrom(src => src.Ihi))
                .ForMember(dest => dest.MRN, opt => opt.MapFrom(src => src.Mrn))
                .ForMember(dest => dest.Name, opt => opt.MapFrom(src => string.Format("{0}, {1}", src.FamilyName, src.GivenNames)))
                .ForMember(dest => dest.Ward, opt => opt.MapFrom(src => src.Ward))
                .ForMember(dest => dest.Room, opt => opt.MapFrom(src => src.Room))
                .ForMember(dest => dest.Bed, opt => opt.MapFrom(src => src.Bed))
                ;
        }

        /// <summary>
        /// Returns the name of the mapping profile.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="18 November 2013">Initial version.</change>
        /// </history>
        public override string ProfileName
        {
            get { return this.GetType().Name; }
        }

        #endregion

    }
}
